import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.Random;
import java.util.*;
/**
 * Write a description of class Desert here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Tablero extends World
{
    private Random r = new Random();
    private List<Personaje> personajes;
    /**
     * Constructor for objects of class Desert.
     * 
     */
    //constructor
    public Tablero()
    {    
        // Create a new world with 600x400 cells with a cell size of 1x1 pixels.
        super(10, 10, 60); 
        setBackground("fondo.jpg");
        
        //se agregan todos los personajes del juego
        Personaje madre_monte = new Personaje(0, -1);
        madre_monte.setJob("M");
        addObject(madre_monte, 1, 1);
        
        Personaje sacerdote_1 = new Personaje();
        sacerdote_1.setJob("S");
        addObject(sacerdote_1, 4, 4);
        
        Personaje sacerdote_2 = new Personaje();
        sacerdote_2.setJob("S");
        addObject(sacerdote_2, 3, 2);
        
        Personaje nino_1 = new Personaje();
        nino_1.setJob("N");
        addObject(nino_1, 6, 6);
        
        Personaje nino_2 = new Personaje();
        nino_2.setJob("N");
        addObject(nino_2, 2, 3);
        
        Personaje campesino_1 = new Personaje();
        campesino_1.setJob("C");
        addObject(campesino_1, 8, 8);
        
        Personaje campesino_2 = new Personaje();
        campesino_2.setJob("C");
        addObject(campesino_2, 7, 7);
        
        Personaje lenador_1 = new Personaje();
        lenador_1.setJob("L");
        addObject(lenador_1, 8, 1);
        
        Personaje lenador_2 = new Personaje();
        lenador_2.setJob("L");
        addObject(lenador_2, 2, 7);
        
        //se agregan los obstaculos y las frutas
        Obstaculo piedra = new Obstaculo();
        addObject(piedra, 5, 5);
        
        Obstaculo piedra_2 = new Obstaculo();
        addObject(piedra_2, 3, 4);
        
        Frutas frutas_1 = new Frutas();
        addObject(frutas_1, 7, 8);
        
        Frutas frutas_2 = new Frutas();
        addObject(frutas_2, 7, 5);
        
    }
    
    //funcion que busca todas las colisiones del tablero
    public void act()
    {
        removerMuertos(getObjects(Personaje.class));         
        
        for(int i = 0; i < getHeight(); ++i)
        {
            for(int j = 0; j <= getWidth(); ++j)
            {
                personajes = getObjectsAt(i, j, Personaje.class);
                
                if(personajes.size() > 1)
                {   
                    Personaje personaje_1 = personajes.get(0);
                    Personaje personaje_2 = personajes.get(1);
                    pelea(personaje_1, personaje_2);           
                }
                else if(personajes.size() == 1)
                {
                    Personaje personaje_1 = personajes.get(0);
                    recolectarDeposito(personaje_1);
                }   
                for(Personaje personajito:personajes)
                {
                    if(personajito.getJob() == 1)
                    {
                        if(personajito.getVida() <= 0)
                        {
                            Greenfoot.stop();
                            Greenfoot.setWorld(new GameOver());
                        }
                    }
                }
            }
        }      
    }
    
    //funcion para remover los personajes que tengan 0 o menos de vida
    public void removerMuertos(List<Personaje> muertos)
    {
        for(Personaje personajito : muertos)
        {
            if(personajito.getVida() <= 0)
            {
                removeObject(personajito);
            }
        }
    }
    
    //funcion que se ejecuta cuando un campesino o leñador colisiona con una fruta
    public void recolectarDeposito(Personaje personajito)
    {
        if(personajito.isTouching(Frutas.class))
        {
            if(personajito.getJob() == 4 || personajito.getJob() == 5)
            {
                personajito.curar();
            }                           
        }
    }
    
    //funcion que se llama cuando la madre monte se encuentra con otro personaje en una casilla
    public void pelea(Personaje personaje_1, Personaje personaje_2)
    {
        if(personaje_1.getJob() == 1)
        {
            if(personaje_2.getJob() == 2 || personaje_2.getJob() == 3)
            {
                personaje_1.perdio();
            }
            else if (personaje_2.getJob() == 3 || personaje_2.getJob() == 4)
            {
                personaje_2.perdio();
            }
        }
    }
    
    //funcion para remover a los personajes que estan muertos

    public void removerObjeto(greenfoot.Actor cls)
    {
        removeObject(cls);
    }
}
